/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.DefaultProgressMonitor;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.sysman.oii.oiif.oiifr.OiifrAPIProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class InstallProgressMonitor
extends DefaultProgressMonitor
implements OiifrAPIProgressActionListener,
OiixProgressListener {
    private static final Logger logger = Logger.getLogger(InstallProgressMonitor.class.getName());
    private long bytes;
    private long totalBytes;
    private int currentPhase;

    public InstallProgressMonitor() {
    }

    public InstallProgressMonitor(CompositeJob compositeJob, ProgressUI<?> progressUI) {
        super(compositeJob, progressUI);
    }

    public void addBytes(int bytes) {
        this.bytes += (long)bytes;
        super.setProgress((float)((double)this.bytes / (double)this.totalBytes));
    }

    public void addPercentage(int percent) {
    }

    public void onDoneProgress() {
    }

    public void removeBytes(int bytes) {
    }

    public void setStatus(String status) {
        this.log(Level.INFO, status, new Object[0]);
    }

    public void setTitle(String status) {
        this.log(Level.INFO, status, new Object[0]);
    }

    public void setTotalBytes(long bytes) {
        logger.log(Level.INFO, "InstallProgressMonitor: Total Bytes to Install {0}", bytes);
        this.totalBytes = bytes;
        super.nextJob();
    }

    public boolean isNewProgressUsed() {
        return false;
    }

    public void onCurrentComponent(String component) {
        String message = OiifrProgressPhases.getComponentInProgressString((int)this.currentPhase, (Object[])new String[]{component});
        this.log(Level.INFO, message, new Object[0]);
    }

    public void onDoneDeinstall() {
    }

    public void onDonePhase(int phase) {
        int phaseIndex = OiifrProgressPhases.getPhaseIndex((int)phase);
        Job task = this.getJob(phaseIndex);
        if (task != null) {
            task.setStatus(Status.SUCCEEDED);
        }
        logger.log(Level.INFO, "InstallProgressMonitor: Completed phase {0}", phase);
    }

    public void onResume() {
        Job task = super.getActiveJob();
        if (task != null && !task.isCompleted()) {
            task.setStatus(Status.INPROGRESS);
        }
    }

    public void onStartDeinstall() {
    }

    public void onStartPhase(int phase) {
        logger.log(Level.INFO, "InstallProgressMonitor: Starting phase {0}", phase);
        this.currentPhase = phase;
        int phaseIndex = OiifrProgressPhases.getPhaseIndex((int)phase);
        Job task = this.getJob(phaseIndex);
        if (task != null) {
            task.setStatus(Status.INPROGRESS);
        }
    }

    public void onSuspend() {
        Job task = super.getActiveJob();
        if (task != null && !task.isCompleted()) {
            task.setStatus(Status.SUSPENDED);
        }
    }

    public void onCancel() {
    }

    @Override
    public Job getJob(Object jobId) {
        Job expectedJob = null;
        expectedJob = this.findJob(this.getJobList(), jobId);
        return expectedJob;
    }

    private Job findJob(List<Job> joblist, Object jobId) {
        if (joblist != null) {
            for (Job job : joblist) {
                Job expectedJob;
                Object id = job.getId();
                if (id != null && jobId.equals(id)) {
                    return job;
                }
                if (!(job instanceof CompositeJob) || (expectedJob = this.findJob(((CompositeJob)job).getJobs(), jobId)) == null) continue;
                return expectedJob;
            }
        }
        return null;
    }
}

